' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa BookingObjectManager odpowiada za pobieranie i dodawanie obiektw rezerwacji.
''' Potrafitake pobiera informacje o dostpnych dniach tygodnia w bazie danych.
''' </summary>
''' <remarks>Poniewa klasa ta zawiera tylko metody wspdzielone, jej konstruktor zosta oznaczony jako 
''' prywatny, aby nie mona byo tworzy egzemplarzy klasy.
''' </remarks>
Public Class BookingObjectManager

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy BookingObjectManager.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca list dostpnych obiektw rezerwacji jako DataSet wywoujc metod z klasy BookingObjectManagerDB.
  ''' </summary>
  ''' <returns>DataSet z dostpnymi obiektami rezerwacji zawierajcy dwie kolumny: Id i Title dla kadego obiektu rezerwacji.</returns>
  Public Shared Function GetBookingObjectList() As DataSet
    Return BookingObjectManagerDB.GetBookingObjectList()
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy egzemplarz BookingObject na podstawie jego identyfikatora wywoujc metod z klasy BookingObjectManagerDB.
  ''' </summary>
  ''' <param name="id">Identyfikator obiektu rezerwacji w bazie danych.</param>
  ''' <returns>dany obiekt rezerwacji lub <see langword="null" /> jeli nie znaleziono pozycji w bazie danych.</returns>
  Public Shared Function GetBookingObject(ByVal id As Integer) As BookingObject
    Return BookingObjectManagerDB.GetBookingObject(id)
  End Function

  ''' <summary>
  ''' Zapisuje nowy lub istniejcy obiekt rezerwacji w bazie danych.
  ''' </summary>
  ''' <param name="myBookingObject">Obiekt rezerwacji, ktry ma by zapisany. Jeli <see cref="BookingObject.Id" /> wynosi -1, nowa pozycja jest tworzona, w przeciwnym razie istniejcy egzemplarz jest aktualizowany.</param>
  Public Shared Sub SaveBookingObject(ByVal myBookingObject As BookingObject)
    BookingObjectManagerDB.SaveBookingObject(myBookingObject)
  End Sub

  ''' <summary>
  ''' Zwraca list dostpnych dni roboczych wywoujc metod z klasy BookingObjectManagerDB.
  ''' </summary>
  ''' <returns>DataSet z dostpnymi dniami roboczymi zawierajcy dwie kolumny: identyfikator i opis dnia roboczego.</returns>
  Public Shared Function GetWorkingDays() As DataSet
    Return BookingObjectManagerDB.GetWorkingDays
  End Function

End Class
